using System;

using Rhino.Commands;

namespace RhinoCodePlatform.Rhino3D.Projects.Plugin
{
  [CommandStyle(Rhino.Commands.Style.ScriptRunner)]
  public class ProjectCommand_Python_21073677  : Command
  {
    Rhino.Runtime.PythonScript _script;
    Rhino.Runtime.PythonCompiledCode _compiledCode;

    public Guid CommandId { get; } = new Guid("21073677-c907-4769-97af-fa036d0edcff");

    public override string EnglishName => "RhinoToWrmlStl";

    protected override string CommandContextHelpUrl => "";

    protected override Rhino.Commands.Result RunCommand(Rhino.RhinoDoc doc, Rhino.Commands.RunMode mode)
    {
      if (_compiledCode is null)
      {
        ProjectLibs.InitPythonLibraries();

        _script = Rhino.Runtime.PythonScript.Create();
        _compiledCode = _script.Compile(
            ProjectPlugin.DecryptString("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")
          );
      }

      if (_compiledCode is null)
      {
        Rhino.RhinoApp.WriteLine("The script code for {0} could not be retrieved or compiled.", EnglishName);
        return Rhino.Commands.Result.Failure;
      }

      _script.ScriptContextDoc = doc;
      _script.SetVariable("__name__", "__main__");

      _compiledCode.Execute(_script);

      return Rhino.Commands.Result.Success;
    }
  }
}
