using System;

using Rhino.Commands;

namespace RhinoCodePlatform.Rhino3D.Projects.Plugin
{
  [CommandStyle(Rhino.Commands.Style.ScriptRunner | Rhino.Commands.Style.Hidden)]
  public class ProjectCommand_Python_28fa2778  : Command
  {
    Rhino.Runtime.PythonScript _script;
    Rhino.Runtime.PythonCompiledCode _compiledCode;

    public Guid CommandId { get; } = new Guid("28fa2778-25f7-4548-b96a-032264433dcd");

    public override string EnglishName => "VerificaLicenza";

    protected override string CommandContextHelpUrl => "";

    protected override Rhino.Commands.Result RunCommand(Rhino.RhinoDoc doc, Rhino.Commands.RunMode mode)
    {
      if (_compiledCode is null)
      {
        ProjectLibs.InitPythonLibraries();

        _script = Rhino.Runtime.PythonScript.Create();
        _compiledCode = _script.Compile(
            ProjectPlugin.DecryptString("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")
          );
      }

      if (_compiledCode is null)
      {
        Rhino.RhinoApp.WriteLine("The script code for {0} could not be retrieved or compiled.", EnglishName);
        return Rhino.Commands.Result.Failure;
      }

      _script.ScriptContextDoc = doc;
      _script.SetVariable("__name__", "__main__");

      _compiledCode.Execute(_script);

      return Rhino.Commands.Result.Success;
    }
  }
}
