using System;
using System.IO;
using System.Text;

namespace RhinoCodePlatform.Rhino3D.Projects.Plugin
{
  static class ProjectLibs
  {
    const string LIBS_DIR_NAME = "libs";
    static bool s_pythonPathInitd = false;

    public static string GetPluginPath()
    {
      string location = typeof(ProjectLibs).Assembly.Location;
      if (string.IsNullOrEmpty(location))
      {
        return string.Empty;
      }

      return Path.GetDirectoryName(location);
    }

    public static void InitPythonLibraries()
    {
      if (s_pythonPathInitd)
        return;

      string pluginpath = GetPluginPath();
      if (string.IsNullOrEmpty(pluginpath))
      {
        return;
      }

      string libpath = Path.Combine(pluginpath, LIBS_DIR_NAME);
      if (!Directory.Exists(libpath))
      {
        s_pythonPathInitd = true;
        return;
      }

      var script = new StringBuilder("import sys\n");
      foreach (var zipfile in Directory.GetFiles(libpath, "*.zip"))
      {
        script.AppendLine($"sys.path.append(r\"{zipfile}\")");
      }

      var s = Rhino.Runtime.PythonScript.Create();
      s.Compile(script.ToString()).Execute(s);

      s_pythonPathInitd = true;
    }
  }
}
